import express from "express";
import compression from "compression";
import helmet from "helmet";

const app = express();
const PORT = process.env.PORT || 3000;

app.use(helmet({ contentSecurityPolicy: false }));
app.use(compression());
app.use(express.static("public", { maxAge: "1d", etag: true }));

app.get("/health", (_req, res) => res.json({ ok: true, uptime: process.uptime() }));

app.listen(PORT, () => console.log(`✅ Costeador de Res corriendo en http://localhost:${PORT}`));
