# Costeador de Res — Método 2 (Node.js)

Aplicación web moderna para costear una res por piezas usando **prorrateo por valor de venta** (Método 2).

## Ejecutar localmente
```bash
npm install
npm run start
# abre http://localhost:3000
```

## Despliegue
- **Render**, **Railway**, **Fly.io** o **Heroku**: sube el repo y define `npm start` como comando de inicio.
- **Docker** (opcional):
```Dockerfile
FROM node:20-alpine
WORKDIR /app
COPY package*.json ./
RUN npm ci --only=production
COPY . .
EXPOSE 3000
CMD ["node","server.js"]
```

## Uso
1. Ingresa el **Costo total de la res (COP)** y el **Peso total (referencia)**.
2. Agrega piezas con **Peso (kg)** y **Venta/kg**.
3. La app calcula: **Ingreso, % del costo, Costo asignado, Costo/kg, Utilidad y Margen**.
4. Usa **Guardar/Cargar** para exportar/importar escenarios y **Exportar CSV** para reportes.
